package MusicLandscape.util.comparators;

import MusicLandscape.entities.Track;

import java.util.Comparator;

/**
 * Encapsulates the concept of comparing two tracks by title.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet05
 */
public class TitleComparator implements Comparator<Track> {
    /**
     * Compares two tracks by title.<br>
     * Comparison is performed lexicographically on the titles of the two tracks.
     * <p>
     * This comparator assumes non-null arguments.
     *
     * @param o1 the first object to be compared.
     * @param o2 the second object to be compared.
     * @return a negative integer, zero, or a positive integer as the
     * first argument is less than, equal to, or greater than the
     * second.
     * @throws NullPointerException if an argument is null and this
     *                              comparator does not permit null arguments
     * @throws ClassCastException   if the arguments' types prevent them from
     *                              being compared by this comparator.
     */
    @Override
    public int compare(Track o1, Track o2) {
        return o1.getTitle().compareToIgnoreCase(o2.getTitle());
    }

    /**
     * the string representation is "by title" (without quotes)
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "by title";
    }
}
